
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.BO
{
    public class Instructor : PI.FM.N000.Base.BL.BO.Base
    {
        public Instructor(Gemini.Core.BL.Interface.DBD.IDBDBase DBDBase)
            : base(DBDBase) { }

        #region Public members
        public string Title
        {
            get { return GetValue<string>("Title"); }
            set { SetValue<string>("Title", value); }
        }
        public string Forename
        {
            get { return GetValue<string>("Forename"); }
            set { SetValue<string>("Forename", value); }
        }
        public string Surename
        {
            get { return GetValue<string>("Surename"); }
            set { SetValue<string>("Surename", value); }
        }
        public string Tel
        {
            get { return GetValue<string>("Tel"); }
            set { SetValue<string>("Tel", value); }
        }
        public string Email
        {
            get { return GetValue<string>("Email"); }
            set { SetValue<string>("Email", value); }
        }
        public long? UserID
        {
            get { return GetValue<long?>("UserID"); }
            set { SetValue<long?>("UserID", value); }
        }
        public long? SchoolID
        {
            get { return GetValue<long?>("SchoolID"); }
            set { SetValue<long?>("SchoolID", value); }
        }
        #endregion

        public override string DisplayValue
        {
            get
            {
                return String.Format("{0} {1} {2}", Title, Forename, Surename);
            }
        }

        /// <summary>
        /// Haslo na potrzeby API do EduFarmy uzupelniane podczas
        /// przetwarzania obiektu API.Model.GTeacher na obiekt BO.Student
        /// </summary>
        public string TmpPassword { get; set; }

        /// <summary>
        /// Zwraca nauczyciela API, nalezy pamietac o ustawieniu property VirtualPassword !!
        /// </summary>
        /// <returns></returns>
        internal BL.API.Model.GTeacher GetApiObject()
        {
            return new API.Model.GTeacher() { email = Email, id = UserID.ToString(), name = Forename, surname = Surename, school_id = SchoolID.HasValue ? SchoolID.ToString() : string.Empty };
        }

        /// <summary>
        /// Przepisuje wartosci z obiektu API do BO
        /// </summary>
        /// <param name="Teacher"></param>
        internal void Assign(API.Model.GTeacher Teacher)
        {
            UserID = long.Parse(Teacher.id);
            Email = Teacher.email;
            Forename = Teacher.name;
            Surename = Teacher.surname;
            SchoolID = string.IsNullOrEmpty(Teacher.school_id) ? null : (long?)long.Parse(Teacher.school_id);
        }

        #region Search
        public new class Search : PI.FM.N000.Base.BL.BO.Base.Search
        {
            public long? SchoolID { get; set; }
            public long? UserID { get; set; }
            public string Forename { get; set; }
            public string Surename { get; set; }
            public string Email { get; set; }
        }
        #endregion
    }
}
